package ie.ucd.sixth.adaptor.database;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import ie.ucd.sixth.core.databroker.IQueryDataReceiver;
import ie.ucd.sixth.core.misc.Credentials;
import ie.ucd.sixth.core.query.IQuery;
import ie.ucd.sixth.core.receiver.IDataReceiver;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.Modality;

public class DataReceiver implements IDataReceiver, IQueryDataReceiver {
	
	private ServiceRegistration<IDataReceiver> registration;
	String[] sensorValues;
	DatabaseAccess  dbac;
	String tableName = "davisstation_master";
	
	public DataReceiver(BundleContext context){
		
		registration = context.registerService(IDataReceiver.class, this, null);
	}

	@Override
	public Credentials getCredentials() {
		// TODO Auto-generated method stub
		return null;
		//return new Credentials("DataReceiver","IDataReceiver",0);
	}

	@Override
	public void unregister() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void receive(ISensorData sensorData) {
		// TODO Auto-generated method stub
		System.out.println("Data Received : " + sensorData);
		sensorValues = new String[19];
		sensorValues[0] = currentTime();
		sensorValues[1] = sensorData.getValue(Modality.Barometer);
		sensorValues[2] = sensorData.getValue(Modality.TempInside);
		sensorValues[3] = sensorData.getValue(Modality.HumInside);
		sensorValues[4] = sensorData.getValue(Modality.TempOutside);
		sensorValues[5] = sensorData.getValue(Modality.WindSpeed);
		sensorValues[6] = sensorData.getValue(Modality.WindSpeed10min);
		sensorValues[7] = sensorData.getValue(Modality.WindDir);
		sensorValues[8] = sensorData.getValue(Modality.HumOutside);
		sensorValues[9] = sensorData.getValue(Modality.Rain);
		sensorValues[10] = sensorData.getValue(Modality.UV);
		sensorValues[11] = sensorData.getValue(Modality.SolarRad);
		sensorValues[12] = sensorData.getValue(Modality.Storm);
		sensorValues[13] = sensorData.getValue(Modality.dayRain);
		sensorValues[14] = sensorData.getValue(Modality.monthRain);
		sensorValues[15] = sensorData.getValue(Modality.yearRain);
		sensorValues[16] = sensorData.getValue(Modality.sunRise);
		sensorValues[17] = sensorData.getValue(Modality.sunSet);
		sensorValues[18] = sensorData.getValue(Modality.Battery);
		
		dbac = new DatabaseAccess();
		dbac.InsertToDavisStations(tableName, sensorValues);
		
	}

	@Override
	public void receive(ISensorData data, IQuery query) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void receive(String notification, IQuery query) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getIdentity() {
		// TODO Auto-generated method stub
		//return null;
		return "DataReceiver";
	}
	
	public String currentTime(){
		
		String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
		return sdf.format(cal.getTime());
	}

}
